'use strict';

function BCPChattelModalCtrl($scope, BanksList, STList, STCurrentList, $window){
    var elementId = "#modal-chattel-offers";
    $scope.disableSave = true;

    $scope.CurrentAccount = BanksList.getCurrentAccount();

    $scope.selectedItem = false;
    $scope.typeSymbol = '';

    $scope.showAlert = false;

    $scope.maxValue = 1;

    $scope.buy = {
        price: 0
        ,depreciation: 0
        ,account: {
            value: 0
        }
        ,loan: {
            value: 0
            ,type: {}
        }
    }


    $scope.depreciationTypeValues = {
        MOTO: 20
        ,KOMP: 30
        ,PHONE: 20
        ,OTHER: 20
    }


    $scope.loans = BanksList.getLoanOptions();

    $scope.$on('Chattel:openWindow', function(event, type){
        $scope.showAlert = false;
        $scope.title = type.name;
        $scope.selectedItem = false;
//        $scope.buy = {
//            price: 0
//            ,account: {
//                quantity: 0
//            }
//            ,loan: {
//                quantity: 0
//                ,type: {}
//            }
//        }

        $scope.typeSymbol = type.symbol;
        $scope.chattelList = [];
        STList.list[type.symbol].forEach(function(item){
            var newItem = angular.copy(item);
            $scope.chattelList.push(newItem);
        });
        $scope.openModal();

        setTimeout(function(){
            $("#modal-chattel-offers .nano").nanoScroller({alwaysVisible: true});
        }, 300);
    });

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.save = function(){
        $scope.showAlert = false;
        if($scope.isDepreciationCorrect())
        {
            var CurrentAccount = BanksList.getCurrentAccount();

            var found = STCurrentList.findById($scope.selectedItem.id);

            if($scope.buy.account.quantity > 0)
            {
                if(found == false)
                {
                    found = STCurrentList.addItem($scope.selectedItem, $scope.buy.account.quantity, false, $scope.buy.depreciation);
                }
                else
                {
                    found.addPosition($scope.buy.account.quantity, false, $scope.buy.depreciation);
                }

                CurrentAccount.company_bank_service_options[0].value -= $scope.buy.account.quantity * $scope.buy.price;
            }

            if($scope.buy.loan.quantity > 0)
            {
                if(found == false)
                {
                    found = STCurrentList.addItem($scope.selectedItem, $scope.buy.loan.quantity, $scope.buy.loan.type, $scope.buy.depreciation);
                }
                else
                {
                    found.addPosition($scope.buy.loan.quantity, $scope.buy.loan.type, $scope.buy.depreciation);
                }

            }
            $scope.closeModal();
        }
        else
        {
            $scope.showAlert = true;
        }
    }

    $scope.isDepreciationCorrect = function(){
        if($scope.showDepreciationRow())
        {
            if($scope.depreciationTypeValues[$scope.typeSymbol] == $scope.buy.depreciation)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        else
        {
            return true;
        }
    }


    /**** NEW FUNCTIONS ***/
    $scope.selectItem = function(item){

        $scope.selectedItem = item;


        $scope.maxValue = Math.floor($scope.CurrentAccount.company_bank_service_options[0].value / item.buy_now_price);

        $scope.buy.price = item.buy_now_price;
        $scope.buy.account.quantity = 0;
        $scope.buy.loan.quantity = 0;
        $scope.buy.loan.type = {};
    }


    $scope.selectLoan = function(loan){
        $scope.buy.loan.type = loan;
    }


    $scope.countItems = function(){
        return Number($scope.buy.account.quantity) + Number($scope.buy.loan.quantity);
    }

    $scope.sumItems = function(){
        return ($scope.buy.account.quantity + $scope.buy.loan.quantity) * $scope.buy.price;
    }

    $scope.isEnoughMoney = function(){
        return ($scope.buy.account.quantity * $scope.buy.price <= $scope.CurrentAccount.company_bank_service_options[0].value)
    }

    $scope.buttonSaveDisabled = function(){
        var disabled = !$scope.isEnoughMoney() && $scope.buy.account.quantity != 0;

        if(!disabled)
        {
            if($scope.buy.loan.quantity + $scope.buy.account.quantity == 0)
            {
                disabled = true;
            }
            else if($scope.buy.loan.quantity > 0 && typeof $scope.buy.loan.type.id == 'undefined' )
            {
                disabled = true;
            }
        }
        return disabled;
    }


    $scope.showDepreciationRow = function(){
        if($scope.buy.account.quantity + $scope.buy.loan.quantity > 0)
        {
            if($scope.typeSymbol == 'MOTO')
            {
                return true;
            }
            else if($scope.buy.price > 3500){
                return true;
            }
        }
        return false;
    }

    $scope.openDepreciationAdvice = function(){
        console.log('its in!');
        $window.open('http://www.wskazniki.gofin.pl/8,210,1,roczne-stawki-amortyzacyjne.html');
    }
}

BCPChattelModalCtrl.$inject = ['$scope', 'BanksList', 'STList', 'STCurrentList', '$window'];
